#!/bin/bash

# lockdevicedoor.sh
#
# Usage: lockdevicedoor.sh <command> <device file> <log file>
#
# Return Codes:
# 1 - Error locking the device door
#
# Author: C. Schuck

COMMAND=$1
DEVICEFILE=$2
LOGFILE=$3

# Start log
echo "-> lockdevicedoor.sh" >> $LOGFILE
echo "(Un)locking device door for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> lockdevicedoor.sh"
actzTrace "XMDA   F: lockdevicedoor.sh: (Un)locking device door for `date`"

# (Un)lock the device door
if ! $COMMAND $DEVICEFILE >> $LOGFILE 2>&1; then
    echo "Couldn't (un)lock the device door...exiting" >> $LOGFILE
    actzTrace "XMDA   F: lockdevicedoor.sh: Couldn't (un)lock the device door...exiting"
    exit 1
fi

actzTrace "XMDA   T: <- lockdevicedoor.sh"
echo "<- lockdevicedoor.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0

